<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddCustomerIdToMailListsSendingServers extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('mail_lists_sending_servers', function (Blueprint $table) {
            $table->integer('customer_id')->unsigned()->nullable();
            $table->foreign('customer_id')->references('id')->on('customers')->onDelete('cascade');
        });

        \DB::statement(sprintf("UPDATE %s AS t INNER JOIN %s AS a ON t.mail_list_id = a.id SET t.customer_id = a.customer_id", table('mail_lists_sending_servers'), table('mail_lists')));
        \DB::statement(sprintf("DELETE FROM %s WHERE customer_id IS NULL", table('mail_lists_sending_servers')));

        Schema::table('mail_lists_sending_servers', function (Blueprint $table) {
            $table->integer('customer_id')->unsigned()->nullable(false)->change();
        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('mail_lists_sending_servers', function (Blueprint $table) {
            //
        });
    }
}
